-- Tabele z pliku ZamowieniaStrukturaZmianaPG.sql muszą zostać utworzone najpierw.

SET search_path TO ZamowieniaZmiana;

CREATE FUNCTION R15_korekta_cen_detalicznych_akcesoriow () RETURNS void AS $$
UPDATE Produkty SET CenaDetaliczna = ROUND(1.35 * 
   (SELECT DISTINCT CenaHurtowa 
    FROM Dostawcy_produktow
    WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu 
      AND CenaHurtowa = 
        (SELECT max(CenaHurtowa) 
         FROM Dostawcy_produktow 
         WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)), 0)
WHERE CenaDetaliczna < 1.35 * 
   (SELECT DISTINCT CenaHurtowa 
    FROM Dostawcy_produktow 
    WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu 
      AND CenaHurtowa = 
        (SELECT max(CenaHurtowa) 
         FROM Dostawcy_produktow 
         WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu) LIMIT 1) 
      AND IDKategorii = 1;
$$ LANGUAGE SQL;

CREATE VIEW R15_korekta_cen_detalicznych_akcesoriow_zapytanie
AS
SELECT CenaDetaliczna, ROUND(1.35 * 
   (SELECT DISTINCT CenaHurtowa 
    FROM Dostawcy_produktow 
    WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu 
      AND CenaHurtowa = 
        (SELECT max(CenaHurtowa) 
         FROM Dostawcy_produktow 
         WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)), 0) As ZaktualizowanaCena
FROM Produkty
WHERE CenaDetaliczna < 1.35 * 
   (SELECT DISTINCT CenaHurtowa 
    FROM Dostawcy_produktow 
    WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu 
      AND CenaHurtowa = 
        (SELECT max(CenaHurtowa) 
         FROM Dostawcy_produktow 
         WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu) LIMIT 1) 
     AND IDKategorii = 1 ;


CREATE FUNCTION R15_korekta_cen_detalicznych_rowerow () RETURNS void AS $$
UPDATE Produkty SET CenaDetaliczna = ROUND(1.45 * 
   (SELECT DISTINCT CenaHurtowa 
    FROM Dostawcy_produktow 
    WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu 
      AND CenaHurtowa = 
        (SELECT min(CenaHurtowa) 
         FROM Dostawcy_produktow 
         WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)), 0)
WHERE CenaDetaliczna < 1.45 * 
   (SELECT DISTINCT CenaHurtowa 
    FROM Dostawcy_produktow 
    WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu 
      AND CenaHurtowa = 
        (SELECT min(CenaHurtowa) 
         FROM Dostawcy_produktow 
         WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)) AND IDKategorii = 2 ;
$$ LANGUAGE SQL;

CREATE VIEW R15_korekta_cen_detalicznych_rowerow_zapytanie
AS
SELECT NumerProduktu, NazwaProduktu, CenaDetaliczna, ROUND(1.45 * 
   (SELECT DISTINCT CenaHurtowa 
    FROM Dostawcy_produktow 
    WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu 
      AND CenaHurtowa = 
        (SELECT min(CenaHurtowa) 
         FROM Dostawcy_produktow 
         WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)), 0) As ZaktualizowanaCena
FROM Produkty 
WHERE CenaDetaliczna < 1.45 * 
   (SELECT DISTINCT CenaHurtowa 
    FROM Dostawcy_produktow 
    WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu 
      AND CenaHurtowa = 
        (SELECT min(CenaHurtowa) 
         FROM Dostawcy_produktow 
         WHERE Dostawcy_produktow.NumerProduktu = Produkty.NumerProduktu)) AND IDKategorii = 2 ;


CREATE FUNCTION R15_korekta_cen_pozno_wyslanych_zamowien () RETURNS void AS $$
UPDATE Dane_zamowien
SET CenaZakupu = ROUND(CenaZakupu * 0.98, 2)
WHERE (NumerZamowienia IN
            (SELECT Zamowienia.NumerZamowienia
             FROM Zamowienia
             WHERE (Zamowienia.DataWysylki - Zamowienia.DataZamowienia) > 30));
$$ LANGUAGE SQL;

CREATE VIEW R15_korekta_cen_pozno_wyslanych_zamowien_zapytanie
AS 
SELECT NumerZamowienia, NumerProduktu, CenaZakupu, ROUND(CenaZakupu * 0.98, 2) As ZaktualizowanaCena
FROM Dane_zamowien
WHERE (NumerZamowienia IN
            (SELECT Zamowienia.NumerZamowienia
             FROM Zamowienia
             WHERE (Zamowienia.DataWysylki - Zamowienia.DataZamowienia) > 30));


CREATE FUNCTION R15_znizka_dla_dobrych_klientow_z_pazdziernika () RETURNS void AS $$
UPDATE Dane_zamowien
SET CenaZakupu = ROUND(CenaZakupu * .95, 2)
WHERE (NumerZamowienia IN
            (SELECT Zamowienia.NumerZamowienia
             FROM Zamowienia
             WHERE Zamowienia.IDKlienta IN
                       (SELECT O2.IDKlienta
                        FROM Zamowienia AS O2 INNER JOIN Dane_zamowien 
                          ON O2.NumerZamowienia = Dane_zamowien.NumerZamowienia
                        WHERE O2.DataZamowienia BETWEEN CAST('2017-10-01' AS Date) 
                          AND CAST('2017-10-31' As Date)
                        GROUP BY O2.IDKlienta
                        HAVING SUM(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) 
                                > 50000)));
$$ LANGUAGE SQL;

CREATE VIEW R15_znizka_dla_dobrych_klientow_z_pazdziernika_zapytanie
AS 
SELECT CenaZakupu, ROUND(CenaZakupu * .95, 2) As ZaktualizowanaCena
FROM Dane_zamowien
WHERE (NumerZamowienia IN
            (SELECT Zamowienia.NumerZamowienia
             FROM Zamowienia
             WHERE Zamowienia.IDKlienta IN
                       (SELECT O2.IDKlienta
                        FROM Zamowienia AS O2 INNER JOIN Dane_zamowien 
                          ON O2.NumerZamowienia = Dane_zamowien.NumerZamowienia
                        WHERE O2.DataZamowienia BETWEEN CAST('2017-10-01' AS Date) 
                          AND CAST('2017-10-31' As Date)
                        GROUP BY O2.IDKlienta
                        HAVING SUM(Dane_zamowien.CenaZakupu * Dane_zamowien.ZamowionaIlosc) 
                                > 50000)));


CREATE FUNCTION R15_aktualizacja_calk_wartosci_zamowien_podzapytanie () RETURNS void AS $$
UPDATE Zamowienia
SET WartoscCalkowita =
         (SELECT SUM(Dane_zamowien.ZamowionaIlosc * Dane_zamowien.CenaZakupu)
          FROM Dane_zamowien
          WHERE Dane_zamowien.NumerZamowienia = Zamowienia.NumerZamowienia);
$$ LANGUAGE SQL;

CREATE VIEW R15_aktualizacja_calk_wartosci_zamowien_podzapytanie_zapytanie
AS 
SELECT WartoscCalkowita, 
         (SELECT SUM(Dane_zamowien.ZamowionaIlosc * Dane_zamowien.CenaZakupu)
          FROM Dane_zamowien
          WHERE Dane_zamowien.NumerZamowienia = Zamowienia.NumerZamowienia) As NowaWartoscCalkowita
FROM Zamowienia;


CREATE FUNCTION R16_dodaj_klienta () RETURNS void AS $$ 
INSERT INTO Klienci 
      (ImieKlienta, NazwiskoKlienta, AdresKlienta, MiastoKlienta, StanZamKlienta, 
          KodPocztowyKlienta, NumKierKlienta, TelefonKlienta)
VALUES ('Mary', 'Baker', '7834 W 32nd Ct', 'Bothell', 'WA', '98011', 425, '555-9876');
$$ LANGUAGE SQL;

CREATE VIEW R16_dodaj_klienta_zapytanie
AS
SELECT 'Mary' As ImieKlienta, 'Baker' As NazwiskoKlienta, '7834 W 32nd Ct' As AdresKlienta, 
    'Bothell' As MiastoKlienta, 'WA' As StanZamKlienta, '98011' As KodPocztowyKlienta, 425 As NumKierKlienta, 
    '555-9876' As TelefonKlienta
FROM Klienci
WHERE IDKlienta = 1001;


CREATE FUNCTION R16_dodaj_pracownika () RETURNS void AS $$
INSERT INTO Pracownicy 
    (ImiePracownika, NazwiskoPracownika, AdresPracownika, MiastoPracownika, StanZamPracownika, 
     KodPocztowyPracownika, NumKierunkPracownika, TelefonPracownika)
VALUES ('Susan', 'Metters', '16547 NE 132nd St', 'Woodinville', 'WA', '98072', 425, '555-7825');
$$ LANGUAGE SQL;

CREATE VIEW R16_dodaj_pracownika_zapytanie
AS
SELECT 'Susan' As ImiePracownika, 'Metters' As NazwiskoPracownika, '16547 NE 132nd St' As AdresPracownika, 
   'Woodinville' As MiastoPracownika, 'WA' As StanZamPracownika, '98072' As KodPocztowyPracownika, 425 As NumKierunkPracownika, 
   '555-7825' As TelefonPracownika
FROM Pracownicy
WHERE IDPracownika = 701;


CREATE FUNCTION R16_dodaj_produkt () RETURNS void AS $$
INSERT INTO Produkty ( NazwaProduktu, CenaDetaliczna, IDKategorii )
   SELECT 'Rower stacjonarny Hot Dog', 895, IDKategorii
   FROM Kategorie 
   WHERE OpisKategorii = 'Rowery';
$$ LANGUAGE SQL;

CREATE VIEW R16_dodaj_produkt_zapytanie
AS 
SELECT 'Rower stacjonarny Hot Dog' As NazwaProduktu, 895 As CenaDetaliczna, IDKategorii
FROM Kategorie 
WHERE
OpisKategorii = 'Rowery';


CREATE FUNCTION R16_dodaj_dostawce () RETURNS void AS $$
INSERT INTO Dostawcy 
    (NazwaDostawcy, AdresDostawcy, MiastoDostawcy, StanSiedzDostawcy, KodPocztowyDostawcy, TelefonDostawcy, 
     FaxDostawcy, StronaInterDostawcy, EmailDostawcy)
VALUES ('Hot Dog Bikes', '1234 Main Street', 'Chicago', 'IL', '60620', '(773) 555-6543', 
    '(773) 555-6542', 'http://www.hotdogbikes.com/', 'Sales@hotdogbikes.com');
$$ LANGUAGE SQL;

CREATE VIEW R16_dodaj_dostawce_zapytanie
AS
SELECT 'Hot Dog Bikes' As NazwaDostawcy, '1234 Main Street' As AdresDostawcy, 
   'Chicago' As MiastoDostawcy, 'IL' As StanSiedzDostawcy, '60620' As KodPocztowyDostawcy, 
   '(773) 555-6543' As TelefonDostawcy, '(773) 555-6542' As FaxDostawcy, 
   'http://www.hotdogbikes.com/' As StronaInterDostawcy, 'Sales@hotdogbikes.com' As EmailDostawcy
FROM Dostawcy
WHERE IDDostawcy = 1;


CREATE FUNCTION R16_zarchiwizuj_dane_zamowien_2017 () RETURNS void AS $$
INSERT INTO Dane_zamowien_archiwum
SELECT NumerZamowienia AS NumerZamowienia, NumerProduktu AS NumerProduktu, CenaZakupu AS CenaZakupu, 
   ZamowionaIlosc AS ZamowionaIlosc
FROM Dane_zamowien
WHERE (NumerZamowienia IN
           (SELECT NumerZamowienia
            FROM Zamowienia
            WHERE (Zamowienia.DataZamowienia < Cast('2018-01-01' As Date))));
$$ LANGUAGE SQL;

CREATE VIEW R16_zarchiwizuj_dane_zamowien_2017_zapytanie
AS 
SELECT NumerZamowienia, NumerProduktu, CenaZakupu, ZamowionaIlosc 
FROM Dane_zamowien
WHERE (NumerZamowienia IN
           (SELECT NumerZamowienia
            FROM Zamowienia
            WHERE (Zamowienia.DataZamowienia < Cast('2018-01-01' As Date))));


CREATE FUNCTION R16_zarchiwizuj_zamowienia_2017 () RETURNS void AS $$
INSERT INTO Zamowienia_archiwum
SELECT NumerZamowienia, DataZamowienia, DataWysylki, IDKlienta, IDPracownika, WartoscCalkowita
FROM Zamowienia
WHERE (DataZamowienia < Cast('2018-01-01' As Date));
$$ LANGUAGE SQL;

CREATE VIEW R16_zarchiwizuj_zamowienia_2017_zapytanie
AS 
SELECT NumerZamowienia, DataZamowienia, DataWysylki, IDKlienta, IDPracownika, WartoscCalkowita
FROM Zamowienia
WHERE (DataZamowienia < Cast('2018-01-01' As Date));


CREATE FUNCTION R16_skopiuj_klienta_jako_pracownika () RETURNS void AS $$
INSERT INTO Pracownicy
   (ImiePracownika, NazwiskoPracownika, AdresPracownika, MiastoPracownika, StanZamPracownika, KodPocztowyPracownika, 
    NumKierunkPracownika, TelefonPracownika)
SELECT ImieKlienta, NazwiskoKlienta, AdresKlienta, MiastoKlienta, StanZamKlienta, KodPocztowyKlienta, 
    NumKierKlienta, TelefonKlienta
FROM Klienci
WHERE (ImieKlienta = 'David') AND (NazwiskoKlienta = 'Smith');
$$ LANGUAGE SQL;

CREATE VIEW R16_skopiuj_klienta_jako_pracownika_zapytanie
AS 
SELECT ImieKlienta, NazwiskoKlienta, AdresKlienta, MiastoKlienta, StanZamKlienta, KodPocztowyKlienta, 
    NumKierKlienta, TelefonKlienta
FROM Klienci
WHERE (ImieKlienta = 'David') AND (NazwiskoKlienta = 'Smith');


CREATE FUNCTION R16_skopiuj_dane_zamowienia_12gru_dla_Keyser () RETURNS void AS $$
INSERT INTO Dane_zamowien
             (NumerZamowienia, NumerProduktu, CenaZakupu, ZamowionaIlosc)
SELECT NumerZamowienia + 1000 As NowyNumerZamowienia, NumerProduktu, CenaZakupu, ZamowionaIlosc
FROM Dane_zamowien
WHERE (NumerZamowienia IN
            (SELECT     NumerZamowienia
             FROM Zamowienia
             WHERE      DataZamowienia = Cast('2017-12-12' As Date) 
               AND IDKlienta = 
                       (SELECT IDKlienta
                        FROM Klienci
                        WHERE ImieKlienta = 'Liz' AND NazwiskoKlienta = 'Keyser')));
$$ LANGUAGE SQL;

CREATE VIEW R16_skopiuj_dane_zamowienia_12gru_dla_Keyser_zapytanie
AS
SELECT NumerZamowienia + 1000 As NowyNumerZamowienia, NumerProduktu, CenaZakupu, ZamowionaIlosc
FROM Dane_zamowien
WHERE (NumerZamowienia IN
            (SELECT NumerZamowienia
             FROM Zamowienia
             WHERE DataZamowienia = Cast('2017-12-12' As Date) 
               AND IDKlienta = 
                       (SELECT IDKlienta
                        FROM Klienci
                        WHERE ImieKlienta = 'Liz' AND NazwiskoKlienta = 'Keyser')));


CREATE FUNCTION R16_skopiuj_zamowienie_12gru_dla_Keyser () RETURNS bigint AS $$
INSERT INTO Zamowienia
         (NumerZamowienia, DataZamowienia, DataWysylki, IDKlienta, IDPracownika, WartoscCalkowita)
SELECT NumerZamowienia + 1000 As NowyNumerZamowienia, Cast('2018-12-06' As Date) AS DataZamowienia, 
    Cast('2018-06-15' As Date) AS DataWysylki, IDKlienta, IDPracownika, WartoscCalkowita
FROM Zamowienia
WHERE (DataZamowienia = Cast('2017-12-12' As Date)) AND (IDKlienta =
                          (SELECT IDKlienta
                           FROM Klienci
                           WHERE ImieKlienta = 'Liz' AND NazwiskoKlienta = 'Keyser'));
SELECT setval('Zamowienia_NumerZamowienia_seq', 
   (SELECT NumerZamowienia + 1000 
    FROM Zamowienia 
	WHERE (DataZamowienia = CAST('2017-12-12' AS Date))
	  AND (IDKlienta =
         (SELECT IDKlienta
          FROM Klienci
          WHERE ImieKlienta = 'Liz' AND NazwiskoKlienta = 'Keyser'))));		  
$$ LANGUAGE SQL;

CREATE VIEW R16_skopiuj_zamowienie_12gru_dla_Keyser_zapytanie
AS 
SELECT NumerZamowienia + 1000 As NowyNumerZamowienia, Cast('2018-12-06' As Date) AS DataZamowienia, 
  Cast('2018-06-15' As Date) AS DataWysylki, IDKlienta, IDPracownika, WartoscCalkowita
FROM Zamowienia
WHERE (DataZamowienia = Cast('2017-12-12' As Date)) AND (IDKlienta =
                          (SELECT IDKlienta
                           FROM Klienci
                           WHERE ImieKlienta = 'Liz' AND NazwiskoKlienta = 'Keyser'));


CREATE FUNCTION R16_skopiuj_listopadowe_dane_zam_AKennedy () RETURNS void AS $$
INSERT INTO Dane_zamowien
             (NumerZamowienia, NumerProduktu, CenaZakupu, ZamowionaIlosc)
SELECT NumerZamowienia + 1000 As NowyNumerZamowienia, NumerProduktu, CenaZakupu, ZamowionaIlosc
FROM Dane_zamowien
WHERE (NumerZamowienia IN
                 (SELECT NumerZamowienia
                  FROM Zamowienia
                  WHERE DataZamowienia BETWEEN Cast('2017-11-01' As Date) AND Cast('2017-11-30' As Date) 
         AND IDKlienta =
                 (SELECT IDKlienta
                  FROM Klienci
                  WHERE ImieKlienta = 'Angel' AND NazwiskoKlienta = 'Kennedy')));
$$ LANGUAGE SQL;

CREATE VIEW R16_skopiuj_listopadowe_dane_zam_AKennedy_zapytanie
AS 
SELECT NumerZamowienia + 1000 As NowyNumerZamowienia, NumerProduktu, CenaZakupu, ZamowionaIlosc
FROM Dane_zamowien
WHERE (NumerZamowienia IN
                 (SELECT NumerZamowienia
                  FROM Zamowienia
                  WHERE DataZamowienia BETWEEN Cast('2017-11-01' As Date) AND Cast('2017-11-30' As Date) 
         AND IDKlienta =
                 (SELECT IDKlienta
                  FROM Klienci
                  WHERE ImieKlienta = 'Angel' AND NazwiskoKlienta = 'Kennedy')));


CREATE FUNCTION R16_skopiuj_listopadowe_zam_AKennedy () RETURNS bigint AS $$
INSERT INTO Zamowienia
          (NumerZamowienia, DataZamowienia, DataWysylki, IDKlienta, IDPracownika, WartoscCalkowita)
SELECT NumerZamowienia + 1000 As NowyNumerZamowienia, Cast('2018-06-15' As Date) AS DataZamowienia, 
     Cast('2018-06-18' As Date) AS DataWysylki, IDKlienta, IDPracownika, WartoscCalkowita
FROM Zamowienia
WHERE (DataZamowienia BETWEEN Cast('2017-11-01' As Date) AND Cast('2017-11-30' As Date)) 
  AND (IDKlienta =
                 (SELECT IDKlienta
                  FROM Klienci
                  WHERE ImieKlienta = 'Angel' AND NazwiskoKlienta = 'Kennedy'));
SELECT setval('Zamowienia_NumerZamowienia_seq', 
	(SELECT Max(NumerZamowienia) FROM Zamowienia));
$$ LANGUAGE SQL;

CREATE VIEW R16_skopiuj_listopadowe_zam_AKennedy_zapytanie
AS 
SELECT NumerZamowienia + 1000 As NowyNumerZamowienia, Cast('2018-06-15' As Date) AS DataZamowienia, 
    Cast('2018-06-18' As Date) AS DataWysylki, IDKlienta, IDPracownika, WartoscCalkowita
FROM Zamowienia
WHERE (DataZamowienia BETWEEN Cast('2017-11-01' As Date) AND Cast('2017-11-30' As Date)) 
  AND (IDKlienta =
                 (SELECT IDKlienta
                  FROM Klienci
                  WHERE ImieKlienta = 'Angel' AND NazwiskoKlienta = 'Kennedy'));


CREATE FUNCTION R17_usun_zarchiw_dane_zamowien_OK () RETURNS void AS $$
DELETE FROM Dane_zamowien
WHERE (NumerZamowienia IN
                   (SELECT NumerZamowienia
                    FROM Dane_zamowien_archiwum));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_zarchiw_dane_zamowien_OK_zapytanie
AS 
SELECT * FROM Dane_zamowien
WHERE (NumerZamowienia IN
                   (SELECT NumerZamowienia
                    FROM Dane_zamowien_archiwum));


CREATE FUNCTION R17_usun_zarchiw_dane_zamowien_ryzykowne () RETURNS void AS $$
DELETE FROM Dane_zamowien
WHERE (NumerZamowienia IN
                   (SELECT NumerZamowienia
                    FROM Zamowienia
                    WHERE Zamowienia.DataZamowienia < Cast('2018-01-01' As Date)));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_zarchiw_dane_zamowien_ryzykowne_zapytanie
AS 
SELECT * FROM Dane_zamowien
WHERE (NumerZamowienia IN
                   (SELECT NumerZamowienia
                    FROM Zamowienia
                    WHERE Zamowienia.DataZamowienia < Cast('2018-01-01' As Date)));

CREATE FUNCTION R17_usun_zarchiwizowane_zamowienia_OK () RETURNS void AS $$
DELETE FROM Zamowienia
WHERE (NumerZamowienia IN
                  (SELECT NumerZamowienia
                   FROM Zamowienia_archiwum));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_zarchiwizowane_zamowienia_OK_zapytanie
AS 
SELECT * FROM Zamowienia
WHERE (NumerZamowienia IN
                  (SELECT NumerZamowienia
                   FROM Zamowienia_archiwum));


CREATE FUNCTION R17_usun_zarchiwizowane_zamowienia_ryzykowne () RETURNS void AS $$
DELETE FROM Zamowienia
WHERE (DataZamowienia < Cast('2018-01-01' As Date));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_zarchiwizowane_zamowienia_ryzykowne_zapytanie
AS 
SELECT * FROM Zamowienia
WHERE (DataZamowienia < Cast('2018-01-01' As Date));


CREATE FUNCTION R17_usun_kategorie_bez_produktow () RETURNS void AS $$
DELETE FROM Kategorie
WHERE (IDKategorii NOT IN
                     (SELECT IDKategorii
                      FROM Produkty));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_kategorie_bez_produktow_zapytanie
AS 
SELECT * FROM Kategorie
WHERE (IDKategorii NOT IN
                     (SELECT IDKategorii
                      FROM Produkty));


CREATE FUNCTION R17_usun_klientow_bez_zamowien () RETURNS void AS $$
DELETE FROM Klienci
WHERE (IDKlienta NOT IN
                     (SELECT IDKlienta
                      FROM Zamowienia));
$$ LANGUAGE SQL;


CREATE VIEW R17_usun_klientow_bez_zamowien_zapytanie
AS 
SELECT * FROM Klienci
WHERE (IDKlienta NOT IN
                     (SELECT IDKlienta
                      FROM Zamowienia));


CREATE FUNCTION R17_usun_pracownikow_bez_zamowien () RETURNS void AS $$
DELETE FROM Pracownicy
WHERE (IDPracownika NOT IN
                     (SELECT IDPracownika
                      FROM Zamowienia));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_pracownikow_bez_zamowien_zapytanie
AS 
SELECT * FROM Pracownicy
WHERE (IDPracownika NOT IN
                     (SELECT IDPracownika
                      FROM Zamowienia));


CREATE FUNCTION R17_usun_nigdy_nie_zamawiane_produkty_1 () RETURNS void AS $$
DELETE 
FROM Dostawcy_produktow
WHERE (Dostawcy_produktow.NumerProduktu NOT IN 
        (SELECT NumerProduktu FROM Dane_zamowien));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_nigdy_nie_zamawiane_produkty_1_zapytanie
AS
SELECT * 
FROM Dostawcy_produktow
WHERE (Dostawcy_produktow.NumerProduktu NOT IN 
        (SELECT NumerProduktu FROM Dane_zamowien));


CREATE FUNCTION R17_usun_nigdy_nie_zamawiane_produkty_2 () RETURNS void AS $$
DELETE FROM Produkty
WHERE (NumerProduktu NOT IN
       (SELECT NumerProduktu
        FROM Dane_zamowien));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_nigdy_nie_zamawiane_produkty_2_zapytanie
AS 
SELECT * FROM Produkty
WHERE (NumerProduktu NOT IN
       (SELECT NumerProduktu
        FROM Dane_zamowien));


CREATE FUNCTION R17_usun_dostawcow_bez_produktow () RETURNS void AS $$
DELETE FROM Dostawcy
WHERE (IDDostawcy NOT IN
                   (SELECT IDDostawcy
                    FROM Dostawcy_produktow));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_dostawcow_bez_produktow_zapytanie
AS 
SELECT * FROM Dostawcy
WHERE (IDDostawcy NOT IN
                   (SELECT IDDostawcy
                    FROM Dostawcy_produktow));


CREATE FUNCTION R17_usun_zerowe_zamowienia_A () RETURNS void AS $$
DELETE FROM Zamowienia
WHERE (WartoscCalkowita = 0);
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_zerowe_zamowienia_A_zapytanie
AS 
SELECT * FROM Zamowienia
WHERE (WartoscCalkowita = 0);


CREATE FUNCTION R17_usun_zerowe_zamowienia_B () RETURNS void AS $$
DELETE FROM Zamowienia
WHERE (NumerZamowienia NOT IN
                      (SELECT NumerZamowienia
                       FROM Dane_zamowien));
$$ LANGUAGE SQL;

CREATE VIEW R17_usun_zerowe_zamowienia_B_zapytanie
AS 
SELECT * FROM Zamowienia
WHERE (NumerZamowienia NOT IN
                      (SELECT NumerZamowienia
                       FROM Dane_zamowien));
